
<?php $__env->startSection('title', __('zatcaintegrationksa::lang.on_boarding')); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('zatcaintegrationksa::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <section class="content">
        <div class="row">
            <?php
                $settings = json_decode($business->zatca_settings, true);

                $pos_settings = json_decode($business->pos_settings, true);

            ?>

            <div class="col-md-4">

                <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
                    <form
                        action="<?php echo e(action([\Modules\ZatcaIntegrationKsa\Http\Controllers\OnBoardingController::class, 'posBussinesUpdate']), false); ?>"
                        method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group d-flex align-items-center">
                            <span class="check-icon">
                                <?php if(!empty($pos_settings['disable_discount'])): ?>
                                    <i class="fas fa-check-circle text-success"></i>
                                <?php else: ?>
                                    <i class="fas fa-times-circle text-danger"></i>
                                <?php endif; ?>
                            </span>
                            <label class="ms-2"><?php echo e(__('lang_v1.disable_discount'), false); ?></label>
                        </div>

                        <div class="form-group d-flex align-items-center">
                            <span class="check-icon">
                                <?php if(!empty($pos_settings['disable_order_tax'])): ?>
                                    <i class="fas fa-check-circle text-success"></i>
                                <?php else: ?>
                                    <i class="fas fa-times-circle text-danger"></i>
                                <?php endif; ?>
                            </span>
                            <label class="ms-2"><?php echo e(__('lang_v1.disable_order_tax'), false); ?></label>
                        </div>

                        <div class="form-group d-flex align-items-center">
                            <div class="form-group">
                                <?php if($business->default_sales_discount == 0): ?>
                                    <i class="fas fa-check-circle text-success"></i>
                                <?php else: ?>
                                    <i class="fas fa-times-circle text-danger"></i>
                                <?php endif; ?>
                                <?php echo Form::label('default_sales_discount', __('zatcaintegrationksa::lang.set_default_sales_discount', ['discount' => ( number_format($business->default_sales_discount, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']) . '%')])); ?>                            </div>
                        </div>

                        <p class="m-5"><?php echo app('translator')->get('zatcaintegrationksa::lang.sync_warning'); ?></p>
                        <div class="form-group">
                            <?php echo Form::submit(__('zatcaintegrationksa::lang.apply_setting'), [
                                'class' => 'tw-dw-btn tw-dw-btn-success tw-text-white tw-dw-btn-lg',
                            ]); ?>

                        </div>
                    </form>
                <?php echo $__env->renderComponent(); ?>
            </div>
            <div class="col-md-4">


                <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
                    <form
                        action="<?php echo e(action([\Modules\ZatcaIntegrationKsa\Http\Controllers\OnBoardingController::class, 'zataSetting']), false); ?>"
                        method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="form-group">
                            <label for="sync_frequency"><?php echo e(__('zatcaintegrationksa::lang.auto_sync'), false); ?></label>
                            <?php echo Form::select(
                                'sync_frequency',
                                [
                                    'disable' => __('zatcaintegrationksa::lang.disable'),
                                    'instant' => __('zatcaintegrationksa::lang.instant'),
                                    'daily' => __('zatcaintegrationksa::lang.daily'),
                                ],
                                $settings['sync_frequency'] ?? null,
                                ['class' => 'form-control', 'required'],
                            ); ?>

                        </div>
                        <div class="mt-2">
                            <small class="form-text text-muted">
                                1. <?php echo e(__('zatcaintegrationksa::lang.disable'), false); ?> : <?php echo e(__('zatcaintegrationksa::lang.disable_description'), false); ?>

                            </small> <br>
                            <small class="form-text text-muted">
                                2. <?php echo e(__('zatcaintegrationksa::lang.instant'), false); ?> : <?php echo e(__('zatcaintegrationksa::lang.instant_description'), false); ?>

                            </small> <br>
                            <small class="form-text text-muted">
                                3. <?php echo e(__('zatcaintegrationksa::lang.daily'), false); ?> : <?php echo e(__('zatcaintegrationksa::lang.daily_description'), false); ?>

                            </small>
                        </div>
                        <br>
                        <div class="form-group mt-2">
                            <?php echo Form::submit(__('messages.save'), ['class' => 'tw-dw-btn tw-dw-btn-success tw-text-white tw-dw-btn-lg']); ?>

                        </div>
                    </form>
                <?php echo $__env->renderComponent(); ?>
            </div>
            <div class="col-md-4">
                <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
                    <div>
                        <h4 class="text-primary"><?php echo app('translator')->get('zatcaintegrationksa::lang.developer_and_simulation_portal'); ?></h4>
                        <div class="row mb-5">
                            <div class="col-md-12">
                                <div class="d-flex justify-content-between">
                                    <strong class="text-left"><?php echo app('translator')->get('zatcaintegrationksa::lang.invoice_synced_developer_portal'); ?></strong>
                                    <span style="margin: 10px"><?php echo e($mode_count->developer_portal_count, false); ?></span>
                                </div>
                                <div class="d-flex justify-content-between mt-2">
                                    <strong><?php echo app('translator')->get('zatcaintegrationksa::lang.invoice_synced_simulation_portal'); ?></strong>
                                    <span style="margin: 10px"><?php echo e($mode_count->simulation_count, false); ?></span>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-md-12 text-center">
                        <a href="<?php echo e(action([\Modules\ZatcaIntegrationKsa\Http\Controllers\ZatcaInvoiceController::class, 'DeleteTestingInvoice']), false); ?>"
                            class="tw-dw-btn tw-dw-btn-secondary btw-dw-btn-lg delete_zatca_invoice"><?php echo app('translator')->get('zatcaintegrationksa::lang.unsync_invoice'); ?></a>
                    </div>
                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>
        <!-- Custom Tabs -->


        <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
            <div class="mb-5">
                <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('zatcaintegrationksa::lang.on_boarding'); ?></h1>
                <p class="tw-text-sm tw-text-gray-600"><?php echo app('translator')->get('zatcaintegrationksa::lang.onboarding_description'); ?></p>
                <p class="tw-text-sm tw-text-gray-600"><?php echo app('translator')->get('zatcaintegrationksa::lang.onboarding_instruction'); ?></p>
                <p class="tw-text-sm tw-text-gray-600"> <strong><?php echo app('translator')->get('zatcaintegrationksa::lang.note'); ?></strong> <?php echo app('translator')->get('zatcaintegrationksa::lang.portal_mode_instruction'); ?></p>
            </div>
            <div class="nav-tabs-custom mt-5">
                <ul class="nav nav-tabs">
                    <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $business_location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="<?php if($index == 0): ?> active <?php endif; ?>">
                            <a href="#cn_<?php echo e($index, false); ?>" data-toggle="tab" aria-expanded="true">
                                <?php echo e($business_location->name, false); ?>

                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div class="tab-content">
                    <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $business_location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $details = json_decode($business_location->zatca_details, true);
                        ?>

                        <?php
                            $response = json_decode($business_location->zatca_response, true);
                        ?>

                        <div class="tab-pane <?php if($index == 0): ?> active <?php endif; ?>" id="cn_<?php echo e($index, false); ?>">
                            <div class="row">
                                <div class="row">
                                    <h2 class="tw-text-xl md:tw-text-2xl tw-font-bold tw-text-black col-md-3">
                                        <?php echo e($business_location->name, false); ?></h2>

                                    <?php if(isset($details['portal_mode'])): ?>
                                        <div
                                            class=" col-md-9 alert <?php echo e($response['success'] ?? null ? 'alert-success' : 'alert-danger', false); ?>">
                                            <span><?php echo e(__('zatcaintegrationksa::lang.portal_mode'), false); ?> :</span>
                                            <?php echo e($mode[$details['portal_mode'] ?? null], false); ?>,
                                            <span><?php echo e(__('zatcaintegrationksa::lang.status'), false); ?> :</span>
                                            <?php echo e($response['success'] ?? null ? 'Success' : 'Failed', false); ?>

                                        </div>
                                    <?php else: ?>
                                        <div class=" col-md-9 alert alert-warning">
                                            <?php echo e(__('zatcaintegrationksa::lang.on_boading_in_complete'), false); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php echo Form::open([
                                    'url' => action(
                                        [\Modules\ZatcaIntegrationKsa\Http\Controllers\OnBoardingController::class, 'update'],
                                        $business_location->id,
                                    ),
                                    'method' => 'PUT',
                                    'id' => 'details_' . $business_location->id,
                                    'files' => true,
                                ]); ?>


                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('portal_mode' . $index, __('zatcaintegrationksa::lang.portal_mode')); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('zatcaintegrationksa::lang.portal_mode_instruction') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                            <?php echo Form::select('portal_mode', $mode, $details['portal_mode'] ?? 'core', [
                                                'class' => 'form-control',
                                                'required',
                                                'placeholder' => __('messages.please_select'),
                                                'id' => 'portal_mode' . $index,
                                            ]); ?>

                                            <button type="button" class="btn btn-info btn-sm mt-2 fill-test-data"
                                                data-index="<?php echo e($index, false); ?>" style="display: none;">
                                                Fill Test Data
                                            </button>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('otp' . $index, __('zatcaintegrationksa::lang.otp')); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('zatcaintegrationksa::lang.auth_otp_instruction') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                            <?php echo Form::number('otp', $details['otp'] ?? null, [
                                                'class' => 'form-control',
                                                'required',
                                                'placeholder' => __('zatcaintegrationksa::lang.otp'),
                                                'id' => 'OTP' . $index,
                                            ]); ?>


                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('email' . $index, __('business.email')); ?>

                                            <?php echo Form::email('email', $details['email'] ?? null, [
                                                'class' => 'form-control',
                                                'required',
                                                'placeholder' => __('business.email'),
                                                'id' => 'email' . $index,
                                            ]); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('common_name' . $index, __('zatcaintegrationksa::lang.common_name')); ?>

                                            <?php echo Form::text('common_name', $details['common_name'] ?? $business_location->name, [
                                                'class' => 'form-control',
                                                'required',
                                                'placeholder' => __('zatcaintegrationksa::lang.common_name'),
                                                'id' => 'common_name' . $index,
                                            ]); ?>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('country_code' . $index, __('zatcaintegrationksa::lang.country_code')); ?>

                                            <?php echo Form::text('country_code', 'SA', ['class' => 'form-control', 'readonly']); ?>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('organization_unit_name' . $index, __('zatcaintegrationksa::lang.organization_unit_name')); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('zatcaintegrationksa::lang.organization_unit_name_instruction') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                            <?php echo Form::text('organization_unit_name', $details['organization_unit_name'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.organization_unit_name'),
                                            ]); ?>

                                        </div>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('organization_name' . $index, __('zatcaintegrationksa::lang.organization_name')); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('zatcaintegrationksa::lang.organization_unit_name_instruction') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                            <?php echo Form::text('organization_name', $details['organization_name'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.organization_name'),
                                            ]); ?>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('egs_serial_number' . $index, __('zatcaintegrationksa::lang.egs_serial_number')); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('zatcaintegrationksa::lang.egs_serial_number_instruction') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                            <?php echo Form::text('egs_serial_number', $details['egs_serial_number'] ?? '1-SDSA|2-FGDS|3-SDFG', [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.egs_serial_number'),
                                            ]); ?>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('vat_number' . $index, __('zatcaintegrationksa::lang.vat_number')); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('zatcaintegrationksa::lang.vat_number_instruction') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                            <?php echo Form::text('vat_number', $details['vat_number'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.vat_number'),
                                            ]); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('vat_name' . $index, __('zatcaintegrationksa::lang.vat_name')); ?>

                                            <?php echo Form::text('vat_name', $details['vat_name'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.vat_name'),
                                            ]); ?>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('invoice_type' . $index, __('zatcaintegrationksa::lang.invoice_type')); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('zatcaintegrationksa::lang.invoice_type_instruction') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                            <?php echo Form::select('invoice_type', $invoice_types, $details['invoice_type'] ?? null, ['class' => 'form-control']); ?>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('registered_address' . $index, __('zatcaintegrationksa::lang.registered_address')); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('zatcaintegrationksa::lang.registered_address_instruction') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                            <?php echo Form::text('registered_address', $details['registered_address'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.registered_address'),
                                            ]); ?>


                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('business_category' . $index, __('zatcaintegrationksa::lang.business_category')); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('zatcaintegrationksa::lang.business_category_instruction') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                            <?php echo Form::text('business_category', $details['business_category'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.business_category'),
                                            ]); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('crn' . $index, __('zatcaintegrationksa::lang.crn')); ?>

                                            <?php echo Form::text('crn', $details['crn'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.crn'),
                                            ]); ?>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('street_name' . $index, __('zatcaintegrationksa::lang.street_name')); ?>

                                            <?php echo Form::text('street_name', $details['street_name'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.street_name'),
                                            ]); ?>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('building_number' . $index, __('zatcaintegrationksa::lang.building_number')); ?>

                                            <?php echo Form::text('building_number', $details['building_number'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.building_number'),
                                            ]); ?>

                                        </div>
                                    </div>
                                </div>
                                <!-- Additional ZATCA Address Details -->


                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('plot_identification' . $index, __('zatcaintegrationksa::lang.plot_identification')); ?>

                                            <?php echo Form::text('plot_identification', $details['plot_identification'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.plot_identification'),
                                            ]); ?>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('sub_division_name' . $index, __('zatcaintegrationksa::lang.sub_division_name')); ?>

                                            <?php echo Form::text('sub_division_name', $details['sub_division_name'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.sub_division_name'),
                                            ]); ?>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('city_name' . $index, __('zatcaintegrationksa::lang.city_name')); ?>

                                            <?php echo Form::text('city_name', $details['city_name'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.city_name'),
                                            ]); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="row">

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('postal_number' . $index, __('zatcaintegrationksa::lang.postal_number')); ?>

                                            <?php echo Form::text('postal_number', $details['postal_number'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.postal_number'),
                                            ]); ?>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <?php echo Form::label('country_name' . $index, __('zatcaintegrationksa::lang.country_name')); ?>

                                            <?php echo Form::text('country_name', $details['country_name'] ?? null, [
                                                'class' => 'form-control',
                                                'placeholder' => __('zatcaintegrationksa::lang.country_name'),
                                            ]); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 text-center">
                                        <?php echo Form::submit(__('messages.submit'), ['class' => 'tw-dw-btn tw-dw-btn-success tw-text-white tw-dw-btn-lg']); ?>

                                    </div>
                                </div>
                                <?php echo Form::close(); ?>

                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php echo $__env->renderComponent(); ?>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        $(document).ready(function() {
            $(document).on('click', 'a.delete_zatca_invoice', function(e) {
                e.preventDefault();
                swal({
                    title: LANG.sure,
                    text: "<?php echo e(__('zatcaintegrationksa::lang.delete_zatca_invoice_help'), false); ?> ",
                    icon: 'warning',
                    buttons: true,
                    dangerMode: true,
                }).then(willDelete => {
                    if (willDelete) {
                        window.location.href = $(this).attr('href');
                    }
                });
            });

            // Show/hide Fill Test Data button based on portal mode selection
            $('[id^="portal_mode"]').on('change', function() {
                const index = this.id.replace('portal_mode', '');
                const $fillButton = $(this).siblings('.fill-test-data');

                if ($(this).val() === 'developer-portal') {
                    $fillButton.show();
                } else {
                    $fillButton.hide();
                }
            });

            // Handle Fill Test Data button click
            $('.fill-test-data').on('click', function() {
                const $form = $(this).closest('form');

                // Fill the form fields with test data, scoped to the current form
                $form.find('input[name="otp"]').val('111222');
                $form.find('input[name="email"]').val('email@gmail.com');
                $form.find('input[name="common_name"]').val('TSTCO');
                $form.find('input[name="organization_unit_name"]').val('TSTCO-SA');
                $form.find('input[name="organization_name"]').val('TSTCO-SA');
                $form.find('input[name="egs_serial_number"]').val('1-SDSA|2-FGDS|3-SDFG');
                $form.find('input[name="vat_number"]').val('300000000000003');
                $form.find('input[name="vat_name"]').val('TSTCO VAT');
                $form.find('select[name="invoice_type"]').val('1100');
                $form.find('input[name="registered_address"]').val('RMRE1234');
                $form.find('input[name="business_category"]').val('Transportations');
                $form.find('input[name="crn"]').val('CRN123456');
                $form.find('input[name="street_name"]').val('Main Street');
                $form.find('input[name="building_number"]').val('123');
                $form.find('input[name="plot_identification"]').val('Plot567');
                $form.find('input[name="sub_division_name"]').val('Zone A');
                $form.find('input[name="city_name"]').val('Riyadh');
                $form.find('input[name="postal_number"]').val('11564');
                $form.find('input[name="country_name"]').val('Saudi Arabia');
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/deltare5/public_html/ztka.deltaretail.com.eg/Modules/ZatcaIntegrationKsa/Resources/views/onboarding/index.blade.php ENDPATH**/ ?>