
<?php $__env->startSection('title', __('sale.sells')); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('zatcaintegrationksa::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Content Header (Page header) -->
    <section class="content-header no-print">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('sale.sells'); ?>
        </h1>
    </section>

    <!-- Main content -->
    <section class="content no-print">
        <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
            <div class="col-md-3">
                <div class="form-group">
                    <?php echo Form::label('zatca_status', __('zatcaintegrationksa::lang.zatca_status') . ':'); ?>

                    <?php echo Form::select(
                        'zatca_status',
                        [
                            'pending' => __('zatcaintegrationksa::lang.pending'),
                            'success' => __('zatcaintegrationksa::lang.success'),
                            'failed' => __('zatcaintegrationksa::lang.failed'),
                        ],
                        null,
                        ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all')],
                    ); ?>

                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <?php echo Form::label('sell_list_filter_location_id',  __('purchase.business_location') . ':'); ?>

                    <?php echo Form::select('sell_list_filter_location_id', $business_locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all') ]); ?>

                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <?php echo Form::label('sell_list_filter_date_range', __('report.date_range') . ':'); ?>

                    <?php echo Form::text('sell_list_filter_date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'readonly']); ?>

                </div>
            </div>
        <?php echo $__env->renderComponent(); ?>
        <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.all_sales')]); ?>
            <?php if(auth()->user()->can('direct_sell.view') ||
                    auth()->user()->can('view_own_sell_only') ||
                    auth()->user()->can('view_commission_agent_sell')): ?>
                <?php
                    $custom_labels = json_decode(session('business.custom_labels'), true);
                ?>
                <table class="table table-bordered table-striped ajax_view" id="sell_table">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('messages.action'); ?></th>
                            <th><?php echo app('translator')->get('zatcaintegrationksa::lang.zatca_status'); ?></th>
                            <th><?php echo app('translator')->get('messages.date'); ?></th>
                            <th><?php echo app('translator')->get('sale.invoice_no'); ?></th>
                            <th><?php echo app('translator')->get('sale.customer_name'); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.contact_no'); ?></th>
                            <th><?php echo app('translator')->get('sale.location'); ?></th>
                            <th><?php echo app('translator')->get('sale.payment_status'); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.payment_method'); ?></th>
                            <th><?php echo app('translator')->get('sale.total_amount'); ?></th>
                            <th><?php echo app('translator')->get('sale.total_paid'); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.sell_due'); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.sell_return_due'); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.shipping_status'); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.total_items'); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.types_of_service'); ?></th>
                            <th><?php echo e($custom_labels['types_of_service']['custom_field_1'] ?? __('lang_v1.service_custom_field_1'), false); ?>

                            </th>
                            <th><?php echo e($custom_labels['sell']['custom_field_1'] ?? '', false); ?></th>
                            <th><?php echo e($custom_labels['sell']['custom_field_2'] ?? '', false); ?></th>
                            <th><?php echo e($custom_labels['sell']['custom_field_3'] ?? '', false); ?></th>
                            <th><?php echo e($custom_labels['sell']['custom_field_4'] ?? '', false); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.added_by'); ?></th>
                            <th><?php echo app('translator')->get('sale.sell_note'); ?></th>
                            <th><?php echo app('translator')->get('sale.staff_note'); ?></th>
                            <th><?php echo app('translator')->get('sale.shipping_details'); ?></th>
                            <th><?php echo app('translator')->get('restaurant.table'); ?></th>
                            <th><?php echo app('translator')->get('restaurant.service_staff'); ?></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot>
                        <tr class="bg-gray font-17 footer-total text-center">
                            <td colspan="5"><strong><?php echo app('translator')->get('sale.total'); ?>:</strong></td>
                            <td class="footer_payment_status_count"></td>
                            <td class="payment_method_count"></td>
                            <td class="footer_sale_total"></td>
                            <td class="footer_total_paid"></td>
                            <td class="footer_total_remaining"></td>
                            <td class="footer_total_sell_return_due"></td>
                            <td colspan="2"></td>
                            <td class="service_type_count"></td>
                            <td colspan="7"></td>
                        </tr>
                    </tfoot>
                </table>
            <?php endif; ?>
        <?php echo $__env->renderComponent(); ?>
    </section>
    <!-- /.content -->
    <div class="modal fade payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>

    <div class="modal fade edit_payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>

    <div class="modal fade show_error" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">

    </div>

    <!-- This will be printed -->
    <section class="invoice print_section" id="receipt_section">
    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('javascript'); ?>
    <script type="text/javascript">
        $(document).ready(function() {
            //Date range as a button
            $('#sell_list_filter_date_range').daterangepicker(
                dateRangeSettings,
                function(start, end) {
                    $('#sell_list_filter_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(
                        moment_date_format));
                    sell_table.ajax.reload();
                }
            );
            $('#sell_list_filter_date_range').on('cancel.daterangepicker', function(ev, picker) {
                $('#sell_list_filter_date_range').val('');
                sell_table.ajax.reload();
            });

            sell_table = $('#sell_table').DataTable({
                processing: true,
                serverSide: true,
                fixedHeader: false,
                aaSorting: [
                    [2, 'desc']
                ],
                "ajax": {
                    "url": "/sells",
                    "data": function(d) {
                        if ($('#sell_list_filter_date_range').val()) {
                            var start = $('#sell_list_filter_date_range').data('daterangepicker')
                                .startDate.format('YYYY-MM-DD');
                            var end = $('#sell_list_filter_date_range').data('daterangepicker').endDate
                                .format('YYYY-MM-DD');
                            d.start_date = start;
                            d.end_date = end;
                        }
                        d.is_direct_sale = 1;
                        d.is_zatca = 1;
                        d.location_id = $('#sell_list_filter_location_id').val();
                        if ($('#zatca_status').length) {
                            d.zatca_status = $('#zatca_status').val();
                        }
                        d = __datatable_ajax_callback(d);
                    }
                },
                scrollY: "75vh",
                scrollX: true,
                scrollCollapse: true,
                columns: [{
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        "searchable": false
                    },
                    {
                        data: 'zatca_status',
                        name: 'zatca_status'
                    },
                    {
                        data: 'transaction_date',
                        name: 'transaction_date'
                    },

                    {
                        data: 'invoice_no',
                        name: 'invoice_no'
                    },
                    {
                        data: 'conatct_name',
                        name: 'conatct_name'
                    },
                    {
                        data: 'mobile',
                        name: 'contacts.mobile'
                    },
                    {
                        data: 'business_location',
                        name: 'bl.name'
                    },
                    {
                        data: 'payment_status',
                        name: 'payment_status'
                    },
                    {
                        data: 'payment_methods',
                        orderable: false,
                        "searchable": false
                    },
                    {
                        data: 'final_total',
                        name: 'final_total'
                    },
                    {
                        data: 'total_paid',
                        name: 'total_paid',
                        "searchable": false
                    },
                    {
                        data: 'total_remaining',
                        name: 'total_remaining'
                    },
                    {
                        data: 'return_due',
                        orderable: false,
                        "searchable": false
                    },
                    {
                        data: 'shipping_status',
                        name: 'shipping_status'
                    },
                    {
                        data: 'total_items',
                        name: 'total_items',
                        "searchable": false
                    },
                    {
                        data: 'types_of_service_name',
                        name: 'tos.name',
                        <?php if(empty($is_types_service_enabled)): ?>
                            visible: false
                        <?php endif; ?>
                    },
                    {
                        data: 'service_custom_field_1',
                        name: 'service_custom_field_1',
                        <?php if(empty($is_types_service_enabled)): ?>
                            visible: false
                        <?php endif; ?>
                    },
                    {
                        data: 'custom_field_1',
                        name: 'transactions.custom_field_1',
                        <?php if(empty($custom_labels['sell']['custom_field_1'])): ?>
                            visible: false
                        <?php endif; ?>
                    },
                    {
                        data: 'custom_field_2',
                        name: 'transactions.custom_field_2',
                        <?php if(empty($custom_labels['sell']['custom_field_2'])): ?>
                            visible: false
                        <?php endif; ?>
                    },
                    {
                        data: 'custom_field_3',
                        name: 'transactions.custom_field_3',
                        <?php if(empty($custom_labels['sell']['custom_field_3'])): ?>
                            visible: false
                        <?php endif; ?>
                    },
                    {
                        data: 'custom_field_4',
                        name: 'transactions.custom_field_4',
                        <?php if(empty($custom_labels['sell']['custom_field_4'])): ?>
                            visible: false
                        <?php endif; ?>
                    },
                    {
                        data: 'added_by',
                        name: 'u.first_name'
                    },
                    {
                        data: 'additional_notes',
                        name: 'additional_notes'
                    },
                    {
                        data: 'staff_note',
                        name: 'staff_note'
                    },
                    {
                        data: 'shipping_details',
                        name: 'shipping_details'
                    },
                    {
                        data: 'table_name',
                        name: 'tables.name',
                        <?php if(empty($is_tables_enabled)): ?>
                            visible: false
                        <?php endif; ?>
                    },
                    {
                        data: 'waiter',
                        name: 'ss.first_name',
                        <?php if(empty($is_service_staff_enabled)): ?>
                            visible: false
                        <?php endif; ?>
                    },
                ],
                "fnDrawCallback": function(oSettings) {
                    __currency_convert_recursively($('#sell_table'));
                },
                "footerCallback": function(row, data, start, end, display) {
                    var footer_sale_total = 0;
                    var footer_total_paid = 0;
                    var footer_total_remaining = 0;
                    var footer_total_sell_return_due = 0;
                    for (var r in data) {
                        footer_sale_total += $(data[r].final_total).data('orig-value') ? parseFloat($(
                            data[r].final_total).data('orig-value')) : 0;
                        footer_total_paid += $(data[r].total_paid).data('orig-value') ? parseFloat($(
                            data[r].total_paid).data('orig-value')) : 0;
                        footer_total_remaining += $(data[r].total_remaining).data('orig-value') ?
                            parseFloat($(data[r].total_remaining).data('orig-value')) : 0;
                        footer_total_sell_return_due += $(data[r].return_due).find('.sell_return_due')
                            .data('orig-value') ? parseFloat($(data[r].return_due).find(
                                '.sell_return_due').data('orig-value')) : 0;
                    }

                    $('.footer_total_sell_return_due').html(__currency_trans_from_en(
                        footer_total_sell_return_due));
                    $('.footer_total_remaining').html(__currency_trans_from_en(footer_total_remaining));
                    $('.footer_total_paid').html(__currency_trans_from_en(footer_total_paid));
                    $('.footer_sale_total').html(__currency_trans_from_en(footer_sale_total));

                    $('.footer_payment_status_count').html(__count_status(data, 'payment_status'));
                    $('.service_type_count').html(__count_status(data, 'types_of_service_name'));
                    $('.payment_method_count').html(__count_status(data, 'payment_methods'));
                },
                createdRow: function(row, data, dataIndex) {
                    $(row).find('td:eq(6)').attr('class', 'clickable_td');
                }
            });


            $(document).on('click', '.sycs_sale', function(e) {
                e.preventDefault(); // Stop the page from loading
                var href = $(this).attr('href');
                var button = $(this); // Store the button element for later use
                $.ajax({
                    method: 'GET',
                    url: href,
                    dataType: 'json',
                    beforeSend: function() {
                        button.html(
                            '<span class="spinner-border spinner-border-sm"></span> Syncing...'
                        ); // Add syncing indicator before the AJAX call
                    },
                    success: function(result) {
                        button.html('Sync'); // Reset button text after syncing
                        if (result.success == true) {
                            toastr.success(result.msg);
                            sell_table.ajax.reload();
                        } else {
                            toastr.error(result.msg);
                            sell_table.ajax.reload();
                        }
                    },
                    complete: function() {
                        sell_table.ajax.reload();
                    }
                });
            });

            $(document).on('click', '.status_fail', function(e) {
                e.preventDefault(); // Stop the page from loading
                var href = $(this).attr('href');
                var button = $(this); // Store the button element for later use
                $.ajax({
                    method: 'GET',
                    url: href,
                    dataType: 'html', // Changed dataType to 'html'
                    beforeSend: function() {
                        button.html(
                            '<span class="spinner-border spinner-border-sm"></span> Loading...'
                        ); // Add loading indicator before the AJAX call
                    },
                    success: function(result) {
                        $('.show_error').html(result)
                            .modal('show');
                    },
                    complete: function() {
                        sell_table.ajax.reload();
                    }
                });
            });


            $(document).on("click", ".download-xml", function(e) {
                e.preventDefault(); // Prevent default link behavior

                let url = $(this).attr("href");
                let link = $("<a>").attr("href", url).appendTo("body");
                link[0].click();
                link.remove();
            });

            // $(document).on("click", ".download-a3-pdf", function(e) {
            //     e.preventDefault(); // Prevent default anchor behavior
            //     alert('Feature Under Development');
            // });



            $(document).on('change',
                '#zatca_status , #sell_list_filter_location_id',
                function() {
                    sell_table.ajax.reload();
                });

            $('#only_subscriptions').on('ifChanged', function(event) {
                sell_table.ajax.reload();
            });
        });
    </script>
    <script src="<?php echo e(asset('js/payment.js?v=' . $asset_v), false); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/deltare5/public_html/ztka.deltaretail.com.eg/Modules/ZatcaIntegrationKsa/Resources/views/sale/sales_list.blade.php ENDPATH**/ ?>